/*
 * Decompiled with CFR 0.152.
 */
package moe.score.pishockzap;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import java.net.URL;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.EnumListEntry;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import moe.score.pishockzap.PishockZapMod;
import moe.score.pishockzap.compat.FloatSliderBuilder;
import moe.score.pishockzap.compat.Translation;
import moe.score.pishockzap.config.PiShockApiType;
import moe.score.pishockzap.config.PishockZapConfig;
import moe.score.pishockzap.config.ShockDistribution;
import moe.score.pishockzap.pishockapi.OpType;
import moe.score.pishockzap.pishockapi.PiShockSerialApi;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_437;

public class PishockZapModConfigMenu
implements ModMenuApi {
    private static final String PISHOCK_CONTROLLER_PAGE_URL = "https://pishock.com/#/control";
    public static final String PISHOCK_ACCOUNT_PAGE_URL = "https://pishock.com/#/account";

    @NonNull
    private static class_437 createConfigScreen(class_437 parent) {
        PishockZapMod mod = Objects.requireNonNull(PishockZapMod.getInstance(), "PishockZapMod instance is null");
        PishockZapConfig config = mod.getConfig();
        PishockZapConfig defaultConfig = new PishockZapConfig();
        ConfigBuilder configBuilder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)Translation.of("title.pishock-zap.config"));
        ConfigCategory generalCategory = configBuilder.getOrCreateCategory((class_2561)Translation.of("title.pishock-zap.config.general"));
        ConfigEntryBuilder entryBuilder = configBuilder.entryBuilder();
        generalCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)Translation.of("title.pishock-zap.config.general.enabled"), config.isEnabled()).setSaveConsumer(config::setEnabled).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.general.enabled")}).setDefaultValue(defaultConfig.isEnabled()).build());
        generalCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)Translation.of("title.pishock-zap.config.general.vibration_only"), config.isVibrationOnly()).setSaveConsumer(config::setVibrationOnly).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.general.vibration_only")}).setDefaultValue(defaultConfig.isVibrationOnly()).build());
        generalCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)Translation.of("title.pishock-zap.config.general.shock_on_health"), config.isShockOnHealth()).setSaveConsumer(config::setShockOnHealth).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.general.shock_on_health")}).setDefaultValue(defaultConfig.isShockOnHealth()).build());
        generalCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)Translation.of("title.pishock-zap.config.general.fractional_damage"), config.isFractionalDamage()).setSaveConsumer(config::setFractionalDamage).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.general.fractional_damage")}).setDefaultValue(defaultConfig.isFractionalDamage()).build());
        ConfigCategory limitsCategory = configBuilder.getOrCreateCategory((class_2561)Translation.of("title.pishock-zap.config.limits"));
        SubCategoryBuilder shockLimitsCategory = entryBuilder.startSubCategory((class_2561)Translation.of("title.pishock-zap.config.limits.shock_limits"));
        shockLimitsCategory.add((AbstractConfigListEntry)((FloatSliderBuilder)((FloatSliderBuilder)((FloatSliderBuilder)((FloatSliderBuilder)PishockZapModConfigMenu.createFloatSlider(entryBuilder, (class_2561)Translation.of("title.pishock-zap.config.limits.duration"), config.getDuration(), 0.1f, 15.0f).setSaveConsumer(config::setDuration)).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.limits.duration")})).setDefaultValue(Float.valueOf(defaultConfig.getDuration()))).setTextGetter(value -> Translation.of("label.pishock-zap.config.duration", String.format("%.3f", value)))).build());
        shockLimitsCategory.add((AbstractConfigListEntry)((FloatSliderBuilder)((FloatSliderBuilder)((FloatSliderBuilder)((FloatSliderBuilder)PishockZapModConfigMenu.createFloatSlider(entryBuilder, (class_2561)Translation.of("title.pishock-zap.config.limits.max_duration"), config.getMaxDuration(), 0.1f, 15.0f).setSaveConsumer(config::setMaxDuration)).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.limits.max_duration")})).setDefaultValue(Float.valueOf(defaultConfig.getMaxDuration()))).setTextGetter(value -> Translation.of("label.pishock-zap.config.duration", String.format("%.3f", value)))).build());
        shockLimitsCategory.add((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)Translation.of("title.pishock-zap.config.limits.vibration_intensity_min"), config.getVibrationIntensityMin(), 1, 100).setSaveConsumer(config::setVibrationIntensityMin).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.limits.vibration_intensity_min")}).setTextGetter(value -> Translation.of("label.pishock-zap.config.vibration_intensity", value)).setDefaultValue(defaultConfig.getVibrationIntensityMin()).build());
        shockLimitsCategory.add((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)Translation.of("title.pishock-zap.config.limits.vibration_intensity_max"), config.getVibrationIntensityMax(), 1, 100).setSaveConsumer(config::setVibrationIntensityMax).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.limits.vibration_intensity_max")}).setTextGetter(value -> Translation.of("label.pishock-zap.config.vibration_intensity", value)).setDefaultValue(defaultConfig.getVibrationIntensityMax()).build());
        shockLimitsCategory.add((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)Translation.of("title.pishock-zap.config.limits.shock_intensity_min"), config.getShockIntensityMin(), 1, 100).setSaveConsumer(config::setShockIntensityMin).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.limits.shock_intensity_min")}).setTextGetter(value -> Translation.of("label.pishock-zap.config.intensity", value)).setDefaultValue(defaultConfig.getShockIntensityMin()).build());
        shockLimitsCategory.add((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)Translation.of("title.pishock-zap.config.limits.shock_intensity_max"), config.getShockIntensityMax(), 1, 100).setSaveConsumer(config::setShockIntensityMax).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.limits.shock_intensity_max")}).setTextGetter(value -> Translation.of("label.pishock-zap.config.intensity", value)).setDefaultValue(defaultConfig.getShockIntensityMax()).build());
        shockLimitsCategory.add(PishockZapModConfigMenu.createShockDistributionDropdown(entryBuilder, "limits.shock_distribution", config.getShockDistribution(), config::setShockDistribution));
        shockLimitsCategory.setExpanded(true);
        limitsCategory.addEntry((AbstractConfigListEntry)shockLimitsCategory.build());
        SubCategoryBuilder damageThresholdsCategory = entryBuilder.startSubCategory((class_2561)Translation.of("title.pishock-zap.config.limits.damage_thresholds"));
        damageThresholdsCategory.add((AbstractConfigListEntry)((FloatSliderBuilder)((FloatSliderBuilder)((FloatSliderBuilder)((FloatSliderBuilder)PishockZapModConfigMenu.createFloatSlider(entryBuilder, (class_2561)Translation.of("title.pishock-zap.config.limits.vibration_threshold"), config.getVibrationThreshold(), 0.0f, 1.0f, 100.0f).setSaveConsumer(config::setVibrationThreshold)).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.limits.vibration_threshold")})).setTextGetter(value -> Translation.of("label.pishock-zap.config.hp", String.format("%.0f", Float.valueOf(value.floatValue() * 100.0f))))).setDefaultValue(Float.valueOf(defaultConfig.getVibrationThreshold()))).build());
        damageThresholdsCategory.add((AbstractConfigListEntry)((FloatSliderBuilder)((FloatSliderBuilder)((FloatSliderBuilder)((FloatSliderBuilder)PishockZapModConfigMenu.createFloatSlider(entryBuilder, (class_2561)Translation.of("title.pishock-zap.config.limits.min_damage"), config.getMinDamage(), 0.0f, 1.0f, 100.0f).setSaveConsumer(config::setMinDamage)).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.limits.min_damage")})).setTextGetter(value -> Translation.of("label.pishock-zap.config.hp", String.format("%.0f", Float.valueOf(value.floatValue() * 100.0f))))).setDefaultValue(Float.valueOf(defaultConfig.getMinDamage()))).build());
        damageThresholdsCategory.add((AbstractConfigListEntry)((FloatSliderBuilder)((FloatSliderBuilder)((FloatSliderBuilder)((FloatSliderBuilder)PishockZapModConfigMenu.createFloatSlider(entryBuilder, (class_2561)Translation.of("title.pishock-zap.config.limits.max_damage"), config.getMaxDamage(), 0.0f, 1.0f, 100.0f).setSaveConsumer(config::setMaxDamage)).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.limits.max_damage")})).setTextGetter(value -> Translation.of("label.pishock-zap.config.hp", String.format("%.0f", Float.valueOf(value.floatValue() * 100.0f))))).setDefaultValue(Float.valueOf(defaultConfig.getMaxDamage()))).build());
        damageThresholdsCategory.setExpanded(true);
        limitsCategory.addEntry((AbstractConfigListEntry)damageThresholdsCategory.build());
        SubCategoryBuilder shockOnDeathCategory = entryBuilder.startSubCategory((class_2561)Translation.of("title.pishock-zap.config.limits.shock_on_death_category"));
        shockOnDeathCategory.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)Translation.of("title.pishock-zap.config.general.shock_on_death"), config.isShockOnDeath()).setSaveConsumer(config::setShockOnDeath).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.general.shock_on_death")}).setDefaultValue(defaultConfig.isShockOnDeath()).build());
        shockOnDeathCategory.add((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)Translation.of("title.pishock-zap.config.limits.shock_intensity_death"), config.getShockIntensityDeath(), 1, 100).setSaveConsumer(config::setShockIntensityDeath).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.limits.shock_intensity_death")}).setTextGetter(value -> Translation.of("label.pishock-zap.config.intensity", value)).setDefaultValue(defaultConfig.getShockIntensityDeath()).build());
        shockOnDeathCategory.add((AbstractConfigListEntry)((FloatSliderBuilder)((FloatSliderBuilder)((FloatSliderBuilder)((FloatSliderBuilder)PishockZapModConfigMenu.createFloatSlider(entryBuilder, (class_2561)Translation.of("title.pishock-zap.config.limits.shock_duration_death"), config.getShockDurationDeath(), 0.1f, 15.0f).setSaveConsumer(config::setShockDurationDeath)).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.limits.shock_duration_death")})).setDefaultValue(Float.valueOf(defaultConfig.getShockDurationDeath()))).setTextGetter(value -> Translation.of("label.pishock-zap.config.duration", String.format("%.3f", value)))).build());
        shockOnDeathCategory.add(PishockZapModConfigMenu.createShockDistributionDropdown(entryBuilder, "limits.shock_distribution_death", config.getShockDistributionDeath(), config::setShockDistributionDeath));
        shockOnDeathCategory.setExpanded(true);
        limitsCategory.addEntry((AbstractConfigListEntry)shockOnDeathCategory.build());
        ConfigCategory debounceCategory = configBuilder.getOrCreateCategory((class_2561)Translation.of("title.pishock-zap.config.debounce"));
        debounceCategory.addEntry((AbstractConfigListEntry)((FloatSliderBuilder)((FloatSliderBuilder)((FloatSliderBuilder)((FloatSliderBuilder)PishockZapModConfigMenu.createFloatSlider(entryBuilder, (class_2561)Translation.of("title.pishock-zap.config.debounce.debounce_time"), config.getDebounceTime(), 0.1f, 60.0f).setSaveConsumer(config::setDebounceTime)).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.debounce.debounce_time")})).setTextGetter(value -> Translation.of("label.pishock-zap.config.time_interval", String.format("%.3f", value)))).setDefaultValue(Float.valueOf(defaultConfig.getDebounceTime()))).build());
        debounceCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)Translation.of("title.pishock-zap.config.debounce.accumulate_duration"), config.isAccumulateDuration()).setSaveConsumer(config::setAccumulateDuration).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.debounce.accumulate_duration")}).setDefaultValue(defaultConfig.isAccumulateDuration()).build());
        debounceCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)Translation.of("title.pishock-zap.config.debounce.accumulate_intensity"), config.isAccumulateIntensity()).setSaveConsumer(config::setAccumulateIntensity).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.debounce.accumulate_intensity")}).setDefaultValue(defaultConfig.isAccumulateIntensity()).build());
        debounceCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)Translation.of("title.pishock-zap.config.debounce.queue_different"), config.isQueueDifferent()).setSaveConsumer(config::setQueueDifferent).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.debounce.queue_different")}).setDefaultValue(defaultConfig.isQueueDifferent()).build());
        ConfigCategory apiCategory = configBuilder.getOrCreateCategory((class_2561)Translation.of("title.pishock-zap.config.api"));
        EnumListEntry apiTypeSwitcher = entryBuilder.startEnumSelector((class_2561)Translation.of("title.pishock-zap.config.api_type"), PiShockApiType.class, (Enum)config.getApiType()).setDefaultValue((Enum)config.getApiType()).setEnumNameProvider(value -> Translation.of("enum.pishock-zap.config.api_type." + value.name().toLowerCase())).setSaveConsumer(config::setApiType).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.api_type")}).build();
        apiCategory.addEntry((AbstractConfigListEntry)apiTypeSwitcher);
        apiCategory.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)Translation.of("description.pishock-zap.config.api_type", Translation.of("enum.pishock-zap.config.api_type.web_v1").method_27694(style -> style.method_10982(Boolean.valueOf(true))))).build());
        SubCategoryBuilder webV1Category = (SubCategoryBuilder)entryBuilder.startSubCategory((class_2561)Translation.of("title.pishock-zap.config.api.web_v1")).setExpanded(true).setDisplayRequirement(() -> apiTypeSwitcher.getValue() == PiShockApiType.WEB_V1);
        webV1Category.add((AbstractConfigListEntry)entryBuilder.startStrField((class_2561)Translation.of("title.pishock-zap.config.api.log_identifier"), config.getLogIdentifier()).setSaveConsumer(config::setLogIdentifier).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.api.log_identifier")}).setDefaultValue(defaultConfig.getLogIdentifier()).build());
        webV1Category.add((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)Translation.of("description.pishock-zap.config.api.web_v1", Translation.addLink(Translation.of("description.pishock-zap.config.api.web_v1.api_key_link"), PISHOCK_ACCOUNT_PAGE_URL), Translation.addLink(Translation.of("description.pishock-zap.config.api.web_v1.share_codes_link"), PISHOCK_CONTROLLER_PAGE_URL))).build());
        webV1Category.add((AbstractConfigListEntry)entryBuilder.startStrField((class_2561)Translation.of("title.pishock-zap.config.api.username"), config.getUsername()).setSaveConsumer(config::setUsername).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.api.username")}).build());
        webV1Category.add((AbstractConfigListEntry)entryBuilder.startStrField((class_2561)Translation.of("title.pishock-zap.config.api.api_key"), config.getApiKey()).setSaveConsumer(config::setApiKey).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.api.api_key")}).build());
        webV1Category.add((AbstractConfigListEntry)entryBuilder.startStrList((class_2561)Translation.of("title.pishock-zap.config.api.share_codes"), config.getShareCodes()).setSaveConsumer(config::setShareCodes).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.api.share_codes")}).setCellErrorSupplier(PishockZapModConfigMenu::isShareCodeInvalid).setExpanded(true).build());
        webV1Category.add((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)Translation.of("description.pishock-zap.config.api.web_v1.disclaimer")).build());
        apiCategory.addEntry((AbstractConfigListEntry)webV1Category.build());
        SubCategoryBuilder localApiCategory = (SubCategoryBuilder)entryBuilder.startSubCategory((class_2561)Translation.of("title.pishock-zap.config.api.local")).setExpanded(true).setDisplayRequirement(() -> apiTypeSwitcher.getValue() == PiShockApiType.SERIAL);
        localApiCategory.add((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)Translation.of("description.pishock-zap.config.api.local")).build());
        localApiCategory.add((AbstractConfigListEntry)entryBuilder.startDropdownMenu((class_2561)Translation.of("title.pishock-zap.config.api.serial_port"), (Object)config.getSerialPort(), Function.identity(), class_2561::method_30163).setSelections(PiShockSerialApi.getSerialPorts()).setSaveConsumer(config::setSerialPort).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.api.serial_port")}).setDefaultValue((Object)defaultConfig.getSerialPort()).build());
        localApiCategory.add((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)Translation.of("description.pishock-zap.config.api.local.device_ids", Translation.addLink(Translation.of("description.pishock-zap.config.api.local.device_ids.link"), PISHOCK_CONTROLLER_PAGE_URL))).build());
        localApiCategory.add((AbstractConfigListEntry)entryBuilder.startIntList((class_2561)Translation.of("title.pishock-zap.config.api.device_ids"), config.getDeviceIds()).setSaveConsumer(config::setDeviceIds).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.api.device_ids")}).setExpanded(true).build());
        apiCategory.addEntry((AbstractConfigListEntry)localApiCategory.build());
        SubCategoryBuilder webhookCategory = (SubCategoryBuilder)entryBuilder.startSubCategory((class_2561)Translation.of("title.pishock-zap.config.api.webhook")).setExpanded(true).setDisplayRequirement(() -> apiTypeSwitcher.getValue() == PiShockApiType.WEBHOOK);
        webhookCategory.add((AbstractConfigListEntry)entryBuilder.startStrField((class_2561)Translation.of("title.pishock-zap.config.api.custom_webhook_url"), config.getCustomWebhookUrl()).setSaveConsumer(config::setCustomWebhookUrl).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config.api.custom_webhook_url")}).setDefaultValue(defaultConfig.getCustomWebhookUrl()).setErrorSupplier(url -> {
            if (apiTypeSwitcher.getValue() != PiShockApiType.WEBHOOK) {
                return Optional.empty();
            }
            if (url.isBlank()) {
                return Optional.of(Translation.of("error.pishock-zap.config.api.custom_webhook_url.empty"));
            }
            try {
                new URL((String)url);
            }
            catch (Exception e) {
                return Optional.of(Translation.of("error.pishock-zap.config.api.custom_webhook_url.invalid"));
            }
            return Optional.empty();
        }).build());
        String allOpTypes = Arrays.stream(OpType.values()).map(Enum::name).collect(Collectors.joining("\", \"", "\"", "\""));
        String allShockDistributions = Arrays.stream(ShockDistribution.values()).map(Enum::name).collect(Collectors.joining("\", \"", "\"", "\""));
        webhookCategory.add((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)Translation.of("description.pishock-zap.config.api.webhook", Translation.of("description.pishock-zap.config.api.webhook.payload", Translation.raw("\"" + OpType.SHOCK.name() + "\"").method_27694(style -> style.method_10977(class_124.field_1076).method_30938(Boolean.valueOf(true)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)Translation.of("tooltip.pishock-zap.config.api.webhook.payload.operation", allOpTypes)))), Translation.raw("26").method_27694(style -> style.method_10977(class_124.field_1076).method_30938(Boolean.valueOf(true)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)Translation.of("tooltip.pishock-zap.config.api.webhook.payload.intensity")))), Translation.raw("1.2").method_27694(style -> style.method_10977(class_124.field_1076).method_30938(Boolean.valueOf(true)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)Translation.of("tooltip.pishock-zap.config.api.webhook.payload.duration")))), Translation.raw("\"" + ShockDistribution.RANDOM.name() + "\"").method_27694(style -> style.method_10977(class_124.field_1076).method_30938(Boolean.valueOf(true)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)Translation.of("tooltip.pishock-zap.config.api.webhook.payload.distribution", allShockDistributions))))).method_27694(style -> style.method_10977(class_124.field_1080)))).build());
        apiCategory.addEntry((AbstractConfigListEntry)webhookCategory.build());
        configBuilder.setSavingRunnable(mod::saveConfig);
        return configBuilder.build();
    }

    @NonNull
    private static Optional<class_2561> isShareCodeInvalid(@NonNull String shareCode) {
        Objects.requireNonNull(shareCode, "shareCode is marked non-null but is null");
        if (shareCode.isBlank()) {
            return Optional.of(Translation.of("error.pishock-zap.config.api.share_codes.entry.empty"));
        }
        if (shareCode.length() < 10 || !shareCode.matches("[0-9A-F]+")) {
            return Optional.of(Translation.of("error.pishock-zap.config.api.share_codes.entry.invalid"));
        }
        return Optional.empty();
    }

    @NonNull
    private static AbstractConfigListEntry<ShockDistribution> createShockDistributionDropdown(@NonNull ConfigEntryBuilder builder, String key, ShockDistribution def, Consumer<ShockDistribution> saveConsumer) {
        Objects.requireNonNull(builder, "builder is marked non-null but is null");
        return builder.startEnumSelector((class_2561)Translation.of("title.pishock-zap.config." + key), ShockDistribution.class, (Enum)def).setDefaultValue((Enum)def).setEnumNameProvider(value -> Translation.of("enum.pishock-zap.config.shock_distribution." + value.name().toLowerCase())).setSaveConsumer(saveConsumer).setTooltip(new class_2561[]{Translation.of("tooltip.pishock-zap.config." + key)}).build();
    }

    @NonNull
    private static FloatSliderBuilder createFloatSlider(@NonNull ConfigEntryBuilder entryBuilder, @NonNull class_2561 fieldNameKey, float value, float min, float max) {
        Objects.requireNonNull(entryBuilder, "entryBuilder is marked non-null but is null");
        Objects.requireNonNull(fieldNameKey, "fieldNameKey is marked non-null but is null");
        return new FloatSliderBuilder(entryBuilder.getResetButtonKey(), fieldNameKey, value, min, max);
    }

    @NonNull
    private static FloatSliderBuilder createFloatSlider(@NonNull ConfigEntryBuilder entryBuilder, @NonNull class_2561 fieldNameKey, float value, float min, float max, float floatScale) {
        Objects.requireNonNull(entryBuilder, "entryBuilder is marked non-null but is null");
        Objects.requireNonNull(fieldNameKey, "fieldNameKey is marked non-null but is null");
        return new FloatSliderBuilder(entryBuilder.getResetButtonKey(), fieldNameKey, value, min, max, floatScale);
    }

    @NonNull
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return PishockZapModConfigMenu::createConfigScreen;
    }
}

